function [cap, hec] = lampCapHec(airT, maxLampT, coolHalf, input)
%LAMPCAPHEC Calculate lamp's heat capacity and heat exchange coefficient
% inputs:
%   airT - average air temperature (C)
%   maxLampT - maximum temperature the lamp reaches (C)
%   coolHalf - time from switch off until lamp reaches (airT+maxLampT)/2 (s)
%   input - energy input to the lamp (W m^{-2})
% outputs:
%   cap - heat capacity of lamp (J K^{-1} m^{-2})
%   hec - heat exchange coefficient of lamp (W K^{-1} m^{-2})

    % when input is on, dlampT/dt = hec/cap(airT-lampT)+input/cap
    % reaches a steady state at maxLampT =>
    % 0 = hec/cap(airT-maxLampT)+input/cap

    hec = input/(maxLampT-airT);

    % when cooling down, dlampT/dt = hec/cap*(airT-lampT)
    % => lampT = airT+k*exp(-hec*t/cap)
    % lampT(0) = maxLampT
    % lampT(coolHalf) = (maxLampT+airT)/2
    % resulting in:

    hecOverCap = -log(1/2)/coolHalf; % hec/cap

    cap = hec/hecOverCap;

end

